// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

int main() {
   using std::plus;
   list<int> l = enum_from(1);
   l = map( stl_to_fun1( bind1st(plus<int>(),1) ), l );
   cout << head(l) << " " << head(tail(l)) << endl;

   l = enum_from_to(1,3);
   cout << foldr( stl_to_fun2( plus<int>() ), 0, l ) << endl;

   return 0;
}

