// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <cmath>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cin;
using std::cout;
using std::endl;

struct ximprove : public c_fun_type<double,double,double> {
   double operator()( double x, double y ) const { 
      return 0.5*(y+x/y);
   }
};
typedef full2<ximprove> improve_type;
improve_type improve;

struct sqtol : public c_fun_type<double,bool> {
   double tolerance;
   double goal;
   sqtol( double g, double t ) : tolerance(t), goal(g) {}
   bool operator()( double try_me ) const { 
      return std::abs(try_me*try_me - goal) <= tolerance;
   }
};

int main() {
   double x;

   cout << "Enter number to find sqrt: " << endl;
   cin >> x;

   list<double> nums( list_until( konst(false), 
                                  improve(x), 1.0));

   list<double> l = nums;
   for( int i=0; i<20; i++ ) {
      cout << head(l) << " ";
      l = tail(l);
   }
   cout << endl;

   double tol;
   cout << "Enter tolerance, and I'll show first value that meets it" << endl;
   cin >> tol;
   cout << until( sqtol(x,tol), improve(x), 1.0) << endl;

   return 0;
}

