// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

// A <-- B      X <-- Y

struct A {
   virtual void f() const =0;
};

struct B : public A {
   void f() const { cout << "B::f()" << endl; }
};

struct X {
   virtual void g() const =0;
};

struct Y : public X {
   void g() const { cout << "Y::g()" << endl; }
};

struct fun_from_A_to_Y 
: public c_fun_type<boost::shared_ptr<A>,boost::shared_ptr<Y> > {
   boost::shared_ptr<Y> operator()( boost::shared_ptr<A> ) const 
   { return boost::shared_ptr<Y>(new Y); }
};

Y* foo( A*, A*, A* ) { return 0; }

int main() {
   fun1<boost::shared_ptr<A>,boost::shared_ptr<Y> > fay = 
      fun_from_A_to_Y();
   fun1<boost::shared_ptr<B>,boost::shared_ptr<X> > fbx = fay;   // woohoo!
   fbx( boost::shared_ptr<B>(new B) )->g();

   boost::shared_ptr<B> rb;
   boost::shared_ptr<const B> rcb = rb;
   //boost::shared_ptr<void> rv = rb;       // unsafe
   if( rcb == rb )
      cout << "yay" << endl;
   //rb = rcb;

   //fun1<A*,X*> oops = fbx;
   //fun1<A*,X*> oops = explicit_convert1<A*,X*>(fbx);
   //fun1<B*,Y*> crap = fbx;

   fun3<A*,A*,A*,Y*> faaay = ptr_to_fun(&foo);
   fun3<B*,B*,B*,X*> fbbbx = faaay;
   B* bn = 0;
   X* xxx = fbbbx(bn)(bn)(bn);
   if( !xxx )
      cout << "yay" << endl;
}
