// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <cassert>
#include <string>
#include <iostream>
#include "prelude.hpp"
using namespace boost::fcpp;

using std::string;
using std::cout;
using std::endl;

int main() {
   int x=1, y=2, z=3;
   string s="foo", t="bar", u="qux";

   list<int> li = cons(x,cons(y,cons(z,NIL)));
   list<string> ls = cons(s,cons(t,cons(u,NIL)));

   assert( head(li) == 1 );
   // list_with<>()() is shorthand to make small lists
   assert( tail(li) == list_with<>()(2,3) );

   ls = compose(tail,tail)(ls);
   assert( head( ls ) == "qux" );
   assert( tail( ls ) == NIL );

   //cout << "Everything passed, now die." << endl;
   //assert( !(tail( ls ) == NIL) );
}
