// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

class Foo {};

int main() {
   list<int> l = enum_from(49);
   cout << monomorphize1<list<int>,int>(head)( l ) << endl;

   cout << monomorphize1<list<int>,char>(head)( l ) << endl;

   // these are illegal (rightly so)
   //cout << monomorphize1<list<char>,char>(head)( l ) << endl;
   //cout << monomorphize1<list<Foo>,Foo>(head)( l ) << endl;

   fun1<int,int> f= inc;
   cout << f(49) << endl;
   fun1<char,char> g= inc;
   cout << g(49) << endl;
   fun1<int,char> h= inc;
   //fun1<int,char> h= make_fun1( monomorphize1<int,char>(inc) );
   cout << h(49) << endl;

   fun2<int,int,bool> ff= greater;
   cout << ff( 3, 4 ) << endl;

   list<int> li = take( 2, l );
   fun2<int,int,int> fp= plus;
   int sum=monomorphize3<fun2<int,int,int>,int,list<int>,int>( foldr )(fp,0,li);
   cout << "sum is " << sum << endl;

   int s = monomorphize2<int,list<int>,int>( foldr(plus) ) (0,li);
   cout << "sum is " << s << endl;

   s = bind2of3(foldr,0) (plus_type(),li);
   cout << "sum is " << s << endl;

   s = bind3of3(foldr,li) (plus_type(),0);
   cout << "sum is " << s << endl;

   return 0;
}

