// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <algorithm>
#include <vector>
#include <iterator>
#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using namespace std;

template <class Kind>
void test() {
   typedef typename Kind::template List<int>::type LI;
   typedef typename LI::iterator Iter;
   LI l = cat( list_with<Kind>()(1,2,3,4,5), list_with<Kind>()(6,7,8,9,10) );
   Iter i = find( l.begin(), l.end(), 5 );
   // prints 5 6 7 8 9 10
   copy( i, l.end(), ostream_iterator<int>( cout, " " ) );
   cout << endl;

   vector<int> v(6);
   copy( i, l.end(), v.begin() );
   LI list( v.begin(), v.end() );
   // prints 5 6 7 8 9 10
   while( list ) {
      cout << head(list) << " ";
      list = tail(list);
   }
   cout << endl;
}

int main() {
   test<UseList>();
   test<UseOddList>();
   test<UseStrictList>();
   return 0;
}

