// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

struct Fact : public c_fun_type<int,int> {
   mutable int count;
   Fact() : count(0) {}
   int operator()( int x ) const {
      if( x==0 ) { cout << count << endl; return 1; }
      else { count++; return x * (*this)(x-1); }
   }
} fact;

int main() {
   cout << fact(5) << endl;
   cout << fact(5) << endl;

   Fact fa, fb;
   fun1<int,int> f = fa;
   fun1<int,int> g = fa;
   fun1<int,int> h = fb;

   f(7);
   g(8);
   h(9);
   
   fun1<int,int> i( h );
   i(2);

   return 0;
}
