// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

// A <-- B      X <-- Y

struct A {
   virtual void f() const =0;
};

struct B : public A {
   void f() const { cout << "B::f()" << endl; }
};

struct X {
   virtual void g() const =0;
};

struct Y : public X {
   void g() const { cout << "Y::g()" << endl; }
};

struct fun_from_A_to_Y : public c_fun_type<A*,Y*> {
   Y* operator()( A* ) const { return new Y; }
};

Y* return_y() { return new Y; }
Y* ayy(A*,A*) { return new Y; }

int main() {
   fun1<A*,Y*> fay = fun_from_A_to_Y();
   fun1<B*,X*> fbx = fay;          // subtype polymorphism

   fun1<int,int> add3 = boost::fcpp::plus(3);   // implicit direct->indirect

   fun0<Y*> fy = ptr_to_fun(&return_y);
   fun0<X*> fx = fy;

   fun2<A*,A*,Y*> fayy = ptr_to_fun(&ayy);
   fun2<B*,B*,X*> fbbx = fayy;
   fbx = fayy(new B);

   //fun0<int> foo = 3;   // error message sucks
}
