// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include "prelude.hpp"
#include <iostream>

using namespace boost::fcpp;

using std::cout;
using std::endl;

template<class F, class G>
class AddHelper {
  F f;
  G g;
public:
  AddHelper(const F& an_f, const G& a_g) : f(an_f), g(a_g) {}

  template <class I>
  struct sig : public fun_type<typename RT<F,I>::result_type> {};

  template <class I>
  typename sig<I>::result_type operator()( const I& i ) const {
    return f(i)+g(i);
  }
};

struct Add {
  template <class F, class G>
  struct sig: public fun_type<AddHelper<F,G> > {};

  template <class F, class G>
  AddHelper<F,G> operator() (F f, G g) const { return AddHelper<F,G>(f,g); }
} add;

int main() {
  cout << add( plus(3), plus(6) )(7) << endl;

  cout << compose2( plus, plus(3), plus(6) )(7) << endl;

  fun2<int,int,int> f = plus;
  cout << f(3,5) << endl;
  
  // Test automatic currying.
  cout << f(3)(5) << endl;

  // Really test automatic currying! f is treated as a function of 1 argument
  // (in which case it returns a function of one argument). When it is
  // curried explicitly, it becomes a 0-argument function returning a 1-arg
  // function.
  fun0< fun1<int,int> > g = thunk1(f, 5);
  cout << g()(3) << endl;
}
