// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

#ifdef REAL_TIMING
#  include "timer.h"
#else
struct Timer { int ms_since_start() { return 0; } };
#endif

using namespace boost::fcpp;

using std::cout; using std::endl;

#ifndef NUM
#define NUM 12000
#endif

using namespace boost::fcpp;

struct Merge {
  template <class L, class M>
  struct sig : public fun_type<odd_list<typename L::value_type> > {};

  template <class T>
  odd_list<T> operator()( const list<T>& a, const list<T>& b ) const {
    T x = head(a);
    T y = head(b);
    if( x < y )
      return cons( x, thunk2(Merge(),tail(a),b));
    else if( x > y )
      return cons( y, thunk2(Merge(),a,tail(b)));
    else
      return cons( x,
                thunk2(Merge(),tail(a),tail(b)));
  }
} merge;

// Yes, yes, this is not ISO C++...
typedef long long int FOO;

struct Hamming : public c_fun_type< list<FOO> > {
   list<FOO> operator () () const {
      using boost::fcpp::multiplies;
      static list<FOO> h = Hamming();
      static list<FOO> x = thunk2(map,multiplies((FOO)2),h);
      static list<FOO> y = thunk2(map,multiplies((FOO)3),h);
      static list<FOO> z = thunk2(map,multiplies((FOO)5),h);
      static list<FOO> m1= thunk2( merge, x, y );
      static list<FOO> m2= thunk2( merge, m1, z );
      return cons( (FOO)1, m2 );
   }
} hamming;

int main() {
   Timer timer;
   cout << "The " << NUM << "th hamming number is: ";
   int start = timer.ms_since_start();
      cout << (long) at( hamming(), NUM ) << endl;
   int end = timer.ms_since_start();
   cout << "took " << end-start << " ms" << endl;
}

