// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#define BOOST_FCPP_ENABLE_LAMBDA
#include "prelude.hpp"

using std::cout;
using std::endl;
using namespace boost::fcpp;

template <class StateType>
struct StateViaPtrM {
   // M a = StateType* -> a
   typedef RT<compose_type,ignore_type,const_x_type>::result_type unit_type;
   static unit_type unit;

   struct XBind {
      template <class M, class K> struct sig : public fun_type<
         typename LE<LAM<LV<1>,CALL<CALL<K,CALL<M,LV<1> > >,LV<1> > >
         >::type> {};
      template <class M, class K>
      typename sig<M,K>::result_type
      operator()( const M& m, const K& k ) const {
         lambda_var<1> S;
         return lambda(S)[ k[m[S]][S] ];
      }
   };
   typedef full2<XBind> bind_type;
   static bind_type bind;

   typedef dereference_type Get;
   static Get get;

   struct XPut {
      template <class TR, class TP> 
         struct sig : public fun_type<empty_type> {};
      template <class T>
      empty_type operator()( const T& x, T* p ) const {
         *p = x;
         return empty;
      }
   };
   typedef full2<XPut> Put;
   static Put put;

   typedef id_type PtrGet;
   static PtrGet ptr_get;
};

template <class StateType>
typename StateViaPtrM<StateType>::unit_type StateViaPtrM<StateType>::unit = 
   compose( ignore, const_ );

template <class StateType>
typename StateViaPtrM<StateType>::bind_type StateViaPtrM<StateType>::bind;

template <class StateType>
typename StateViaPtrM<StateType>::Get StateViaPtrM<StateType>::get;

template <class StateType>
typename StateViaPtrM<StateType>::Put StateViaPtrM<StateType>::put;

template <class StateType>
typename StateViaPtrM<StateType>::PtrGet StateViaPtrM<StateType>::ptr_get;

int assign( int *p, int x ) {
   *p = x;
   return x;
}

int main() {
   typedef StateViaPtrM<int> M;
   cout << &M::unit << &M::bind << &M::get << &M::put << endl; // g++ bug
   lambda_var<1> X;
   lambda_var<2> Y;
   int i = 3;
   std::pair<int,int> p = fcomp_m<M>()[ make_pair[X,Y] | 
      X <= M::get, M::put[4], Y <= M::get ]( &i );
   std::cout << p.first << " " << p.second << std::endl;

   i = 0;
   p = fcomp_m<M>()[ make_pair[0,Y] | 
      X <= M::ptr_get, 
      Y <= M::get, 
      ptr_to_fun(&assign)[_,plus[Y,1]], 
      Y <= M::get ]( &i );
   std::cout << p.first << " " << p.second << std::endl;
}
