// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

// take 5 (map odd [1..])
// [True,False,True,False,True]

int main() {
   list<int> li = enum_from( 1 );
   list<bool> lb = map( odd, li );
   lb = take( 5, lb );
   
   // or just
   
   lb = take( 5, map( odd, enum_from(1) ) );

   while( lb ) {
      cout << head(lb) << " ";
      lb = tail(lb);
   }
   cout << endl;
   return 0;
}
   
