// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

/* output should be
0110
0010
0000
1110
1000
0100
0010
0001
*/

template <class Kind>
void test() {
   typedef typename Kind::template List<int>::type LI;
   LI a = list_with<Kind>()(1,2);
   LI b = list_with<Kind>()(1,2,3);
   LI c = list_with<Kind>()(2,3);

   cout << (a<a) << (a<b) << (a<c) << (a<NIL) << endl;
   cout << (b<a) << (b<b) << (b<c) << (b<NIL) << endl;
   cout << (c<a) << (c<b) << (c<c) << (c<NIL) << endl;
   cout << (NIL<a) << (NIL<b) << (NIL<c) << (NIL<NIL) << endl;

   cout << (a==a) << (a==b) << (a==c) << (a==NIL) << endl;
   cout << (b==a) << (b==b) << (b==c) << (b==NIL) << endl;
   cout << (c==a) << (c==b) << (c==c) << (c==NIL) << endl;
   cout << (NIL==a) << (NIL==b) << (NIL==c) << (NIL==NIL) << endl;
}

int main() {
   test<UseList>();
   cout << endl;
   test<UseOddList>();
   cout << endl;
   test<UseStrictList>();
}
