// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <cassert>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

bool prime( int x ) {
   if( x<2 ) return false;
   for( int i=2; i<x; i++ )
      if( x%i == 0 )
         return false;
   return true;
}

bool big( int x ) {
   return x > 100;
}

int main() {
   fun1<int,bool> f = ptr_to_fun(&prime);
   assert( f(11) == true );
   f = ptr_to_fun(&big);
   assert( f(11) == false );

   fun2<int,int,int> g = plus;
   assert( g(3,2) == 5 );
   g = minus; 
   assert( g(3,2) == 1 );

   cout << "ok" << endl;
}
