// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <vector>
#include <algorithm>
#include <cassert>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

int main() {
   list<int> l = take( 5, enum_from(1) );
   std::vector<int> v(5);
   std::copy( l.begin(), l.end(), v.begin() );
   std::reverse( v.begin(), v.end() );
   list<int> r( v.begin(), v.end() );
   assert( r == list_with<>()(5,4,3,2,1) );
   cout << "ok" << endl;
}
