// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <string>
#include <cassert>
#include "prelude.hpp"

using namespace boost::fcpp;

int f( int x, int y ) {
   return 3*x + y;
}

class Foo {
   int n;
public:
   Foo( int nn ) : n(nn) {}
   int bar( int x, int y ) const {
      return n*x + y;
   }
};
 
int main() {
   assert( ptr_to_fun(&f)(3)(1) == 10 );

   Foo foo(3);
   assert( ptr_to_fun(&Foo::bar)(&foo,3)(1) == 10 );
}
