// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"
#include <boost/test/minimal.hpp>

using namespace boost::fcpp;

using std::cout;
using std::endl;

struct Foo {};

struct O {
   int aa;
   O( int a ) : aa(a) {}
   int cf( int x ) const { return x+1; }
   int f( int x ) { return ++aa + x; }
};

int test_main(int,char**) {
   O o(1);
   BOOST_CHECK( ptr_to_fun( &O::cf )( &o, 1 ) == 2 );
   BOOST_CHECK( ptr_to_fun( &O::f  )( &o, 1 ) == 3 );
   BOOST_CHECK( ptr_to_fun( &O::f  )( &o, 1 ) == 4 );
   BOOST_CHECK( ptr_to_fun( &O::cf )( &o, 1 ) == 2 );

   const O p(1);
   BOOST_CHECK( ptr_to_fun( &O::cf )( &p, 1 ) == 2 );
   //cout << ptr_to_fun( &O::f  )( &p, 1 ) << endl;  // good error msg

   boost::shared_ptr<O> r( new O(3) );
   BOOST_CHECK( ptr_to_fun( &O::cf )( r, 1 ) == 2 );
   BOOST_CHECK( ptr_to_fun( &O::f  )( r, 1 ) == 5 );
   BOOST_CHECK( ptr_to_fun( &O::f  )( r, 1 ) == 6 );
   BOOST_CHECK( ptr_to_fun( &O::cf )( r, 1 ) == 2 );

   boost::shared_ptr<const O> s( new O(3) );
   BOOST_CHECK( ptr_to_fun( &O::cf )( s, 1 ) == 2 );
   //cout << ptr_to_fun( &O::f  )( s, 1 ) << endl;  // good error msg

   //cout << ptr_to_fun( &O::cf )( Foo(), 1 ) << endl; 
   //cout << ptr_to_fun( &O::f )( Foo(), 1 ) << endl; 
   return 0;
}

