// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

int f( int x ) {
   cout << "Executing f(" << x << ")" << endl;
   return x;
}

template <class T>
void test( list<T> l ) {
   cout << "Top of test(), about to get first element" << endl;
   at(l,0);
   cout << "after_type demanding first element" << endl;
   at(l,1);
   cout << "after_type demanding second element" << endl;
   at(l,2);
   cout << "after_type demanding third element" << endl;
}

int main() {
   // illustrates laziness of map()
   list<int> k=map(ptr_to_fun(&f), enum_from_to(0, 9));
   test(k);
cout << "----------------------------------" << endl;
   // illustrates how to make calls to map() totally lazy
   list<int> l=thunk2(map,ptr_to_fun(&f),enum_from_to(0, 9));
   test(l);
cout << "----------------------------------" << endl;
   // illustrates eagerness of reverse()
   list<int> m=map(ptr_to_fun(&f), enum_from_to(0, 9));
   m=reverse(m);
   test(m);
cout << "----------------------------------" << endl;
   // easy way to change behavior: reorder map/reverse calls
   list<int> n=reverse(enum_from_to(0, 9));
   n=map(ptr_to_fun(&f),n);
   test(n);
cout << "----------------------------------" << endl;
   // hard/unusual way to change behavior: store thunks, not ints
   list<fun0<int> > o = map( compose(construct1<fun0<int> >(),
                                     thunk2(thunk1,ptr_to_fun(&f))), 
                             enum_from_to(0, 9) );
   o = reverse(o);
   test(o);
   cout << "About to _compute_ first element" << endl;
   at(o,0)();
   cout << "About to _compute_ second element" << endl;
   at(o,1)();
   cout << "About to _compute_ third element" << endl;
   at(o,2)();

   // illustrates general transform for data-laziness
   {
      cout << "---" << endl;
      int x = 3;
      x = f(x);
      x = f(x);
      cout << "foo" << endl;
      cout << x << endl;
   }

   {
      cout << "---" << endl;
      fun0<int> x = const_(3);
      x = compose(ptr_to_fun(&f),x);
      x = compose(ptr_to_fun(&f),x);
      cout << "foo" << endl;
      cout << x() << endl;
   }
}
