// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cerr;
using std::cout;
using std::endl;

struct Insert : public c_fun_type<int,list<int>,list<int> > {
   list<int> operator()( int x, const list<int>& l ) const {
      if( null(l) || (x > head(l)) )
         return cons( x, l );
      else
         return cons( head(l), thunk2(Insert(),x,tail(l)) );
   }
};

struct Isort : public c_fun_type<list<int>,list<int> > {
   list<int> operator()( const list<int>& l ) const {
      return foldr( Insert(), list<int>(), l );
   }
};

int main() {
   list<int> some_list = list_with<>()(3,8,14,5,7);
   some_list = cat( some_list, list_with<>()(21,2,6,19,1) );
   list<int> l = Isort()( some_list );
   while( l ) {
      cerr << head(l) << " ";
      l = tail(l);
   }
   cerr << endl;

   return 0;
}

