// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
using std::cout; using std::endl;

#include <algorithm>
using std::transform; using std::copy;

#include <string>
using std::string;

#include <iterator>
using std::ostream_iterator;

#include <functional>
using std::bind1st;

#include "prelude.hpp"
using boost::fcpp::_;

// This example shows currying and type-inference; boost::fcpp::plus is like
// plus, except that it can infer it argument types and you don't
// need calls like bind1st for partial application (currying is automatic).
int main() {
   string a[] = { "man", "bowl", "ego" };
   string prefix = "super";

#ifdef FCPP_WAY
   transform( a, a+3, a, boost::fcpp::plus(prefix) );
#else // STL way
   transform( a, a+3, a, bind1st(std::plus<string>(),prefix) );
#endif

   copy( a, a+3, ostream_iterator<string>(cout,"\n") );
}

