// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cin;
using std::cout;
using std::endl;

class Counter {
   int count;
public:
   Counter() : count(0)             {}
   int get_count() const            { return count; }
   void increment_count()           { ++count; }
   void increment_count_by( int x ) { count += x; }
};

void show( int x ) {
   cout << "   The counter is " << x << endl;
}

int main() {
   Counter c;
   fun0<void> menu_actions[] = {
      compose( ptr_to_fun( &show ),
                            thunk1(ptr_to_fun(&Counter::get_count),&c) ),
      thunk1( ptr_to_fun( &Counter::increment_count ), &c ),
      thunk2( ptr_to_fun( &Counter::increment_count_by ), &c, 5 ) 
   };
   while( true ) {
      cout << "***Menu: (1) show count (2) increment "
           << "(3) inc. by 5 (4) quit" << endl;
      cout << "Select option: ";
      int choice;
      cin >> choice;
      if( choice==1 || choice==2 || choice==3 )
         menu_actions[choice-1]();
      else
         break;
   }
}

