// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

class Base {
   int x;
   friend class Value;
   friend class Show;
protected:
   Base( int xx, fun0<int> vv, fun0<void> ss ) : x(xx), value(vv), show(ss) {}
public:
   Base(int);
   fun0<int>  const value;
   fun0<void> const show;
};

class Show : public c_fun_type<void> {
   Base* this_;
public:
   Show( Base* c ) : this_(c) {}
   void operator()() const { 
      cout << "I am a base with value " << this_->x << endl; 
   }
}; 

class Value : public c_fun_type<int> {
   Base* this_;
public:
   Value( Base* c ) : this_(c) {}
   int operator()() const { return this_->x; }
}; 

Base::Base(int y) : x(y), 
                    value(Value(this)),
                    show(Show(this)) {}

class Derived : public Base {
   int y;
   friend class DShow;
public:
   Derived(int,int);
};

class DShow : public c_fun_type<void> {
   Derived* this_;
public:
   DShow( Derived* c ) : this_(c) {}
   void operator()() const { 
      cout << "I am a derived with value " 
           << this_->value() << ", " << this_->y << endl; 
   }
}; 

Derived::Derived( int a, int b )
   : Base(a, Value(this), DShow(this)), y(b) {}
   
void f( Base& b ) {
   b.show();
}

int main() {
   Base b(3);
   Derived d(3,4);
   f(b);
   f(d);
}

