// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

class Counter {
   int x;
   friend class CounterIncrement;
   friend class CounterValue;
public:
   Counter();
   fun0<void> increment;
   fun0<int> value;
};

class CounterIncrement : public c_fun_type<void> {
   Counter* this_;
public:
   CounterIncrement( Counter* c ) : this_(c) {}
   void operator()() const { this_->x++; }
}; 

class CounterValue : public c_fun_type<int> {
   Counter* this_;
public:
   CounterValue( Counter* c ) : this_(c) {}
   int operator()() const { return this_->x; }
}; 

Counter::Counter() : x(0), 
                     increment(CounterIncrement(this)),
                     value(make_fun0(CounterValue(this))) {}

int main() {
   Counter a, b;
   cout << a.value() << " " << b.value() << endl;
   a.increment();
   a.increment();
   b.increment();
   cout << a.value() << " " << b.value() << endl;
}

