// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
using std::cout;
using std::endl;
#include "prelude.hpp"
#include "boost/test/minimal.hpp"
using namespace boost::fcpp;

int f(int x) { return 2*x + 1; }
int g(int x) { return 3*x + 1; }
int h(int x) { return 5*x + 1; }

int test_main(int,char**) {
   BOOST_CHECK( f(g(h(1))) == 39 );
   BOOST_CHECK( f(g(h(2))) == 69 );
   BOOST_CHECK( compose( ptr_to_fun(&f), 
                    compose( ptr_to_fun(&g), ptr_to_fun(&h) ) )(1) == 39 );
   BOOST_CHECK( compose( ptr_to_fun(&f), 
                    compose( ptr_to_fun(&g), ptr_to_fun(&h) ) )(2) == 69 );
   BOOST_CHECK( compose( compose( ptr_to_fun(&f), 
                             ptr_to_fun(&g)), ptr_to_fun(&h) )(2) == 69 );
   BOOST_CHECK( (ptr_to_fun(&f) ^of^ ptr_to_fun(&g) 
                ^of^ ptr_to_fun(&h))(1) == 39 );
   BOOST_CHECK( (ptr_to_fun(&f) ^of^ ptr_to_fun(&g) 
                ^of^ ptr_to_fun(&h))(2) == 69 );
   BOOST_CHECK( (&f ^of^ &g ^of^ &h)(1) == 39 );
   BOOST_CHECK( (&f ^of^ &g ^of^ &h)(2) == 69 );
   BOOST_CHECK( (equal(69) ^of^ &f ^of^ &g ^of^ ptr_to_fun(&h))(2) == true );
   return 0;
}
