// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <vector>
#include <string>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::vector;
using std::cout;
using std::endl;
using std::string;

// Demonstrates how FC++ can be used to help make an abstract callback
// interface

class EventFirer {
   typedef vector< fun1<int,void> > VL;
   VL listeners;
public:
   void add_listener( const fun1<int,void>& f ) {
      listeners.push_back( f );
   }
   void fire_event( int x ) {
      for( VL::iterator i=listeners.begin(); i!=listeners.end(); ++i ) {
         (*i)(x);
      }
   }
};

struct Foo {
   void blah( int x ) const {
      cout << "Foo.blah called with " << x << endl;
   }
};

struct Bar {
   void icky( int x, string s ) const {
      cout << "Bar.icky called with " << x << ": " << s << endl;
   }
};

int main() {
   Foo foo;
   Bar bar;
   EventFirer ef;

   string one = "one", two = "two";
   ef.add_listener( ptr_to_fun( &Foo::blah )( &foo )         );
   ef.add_listener( ptr_to_fun( &Bar::icky )( &bar, _, one ) );
   ef.add_listener( ptr_to_fun( &Bar::icky )( &bar, _, two ) );

   ef.fire_event( 3 );

   return 0;
}

