// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

template <class T>
struct Tree {
   virtual ~Tree() {}
   virtual fun1<T,void>& inorder( fun1<T,void>& f ) const = 0;
};

template <class T>
class Node : public Tree<T> {
   T data_;
   Tree<T>* left_;
   Tree<T>* right_;
public:
   Node( T d, Tree<T>* l, Tree<T>* r ) : data_(d),left_(l),right_(r) {}
   fun1<T,void>& inorder( fun1<T,void>& f ) const {
      left_->inorder(f);
      f(data_);
      right_->inorder(f);
      return f;
   }
};
      
template <class T>
struct EmptyNode : public Tree<T> {
   fun1<T,void>& inorder( fun1<T,void>& f ) const {
      return f;
   }
};

struct Dump : public c_fun_type<int,void> {
   Dump() {}
   void operator()(int n) const { cout << n << ","; }
};

int main() {
//     1
//    / \      -
//   2   3
//  / \        -
// 4   5
   Tree<int>* NIL = new EmptyNode<int>;
   Tree<int>* t = new Node<int>(1,
      new Node<int>(2,new Node<int>(4,NIL,NIL),new Node<int>(5,NIL,NIL)),
      new Node<int>(3,NIL,NIL) );
   Dump d;
   fun1<int,void> dd = d;
   t->inorder(dd);
   cout << endl;
   return 0;
}

