// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <typeinfo>
#include <iostream>
#include "prelude.hpp"
#include <boost/test/minimal.hpp>

using namespace boost::fcpp;

using std::cout;
using std::endl;

struct Apply {
   template <class F, class X, class Y> struct sig : public fun_type<
      typename RT<F,X,Y>::result_type> {};

   template <class F, class X, class Y>
   typename sig<F,X,Y>::result_type operator()( F f, X x, Y y ) {
      return f(x,y);
   }
} apply;
   
int test_main(int,char**) {
   BOOST_CHECK( apply( make_pair, 3, 'c' ) == make_pair(3,'c') );
   return 0;
}
