// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_FCPP_SIGNATURE_HPP
#define BOOST_FCPP_SIGNATURE_HPP

#include "config.hpp"
#include "boost/type_traits.hpp"
#include <functional>

namespace boost {
namespace fcpp {

// For use with "result" sigs (std::result_of)
template <class T> struct Type { typedef T type; };

//////////////////////////////////////////////////////////////////////
// Here are the classes with "nested typedefs" which just help us use
// our own type system; these classes are just inherited.
//////////////////////////////////////////////////////////////////////

namespace impl {
   struct Void {};
}

// This set names functoid arguments and results

template <class R>
struct fun_type {
   typedef R result_type;
};

//////////////////////////////////////////////////////////////////////
// Concrete versions
//////////////////////////////////////////////////////////////////////
// This set is used for monomorphic direct functoids; the type names
// are inherited as-is, and also a template-sig is defined so that
// monomorphic direct functoids can mix freely with polymorphic functoids 
// since the latter require a template-sig member

struct i_am_monomorphic {};

template <class A1, class A2 = impl::Void, 
          class A3 = impl::Void, class R = impl::Void>
struct c_fun_type : public fun_type<R>, public i_am_monomorphic {
   typedef A1 first_argument_type;  // imagined std:: ternary adaptable
   typedef A2 second_argument_type; // imagined std:: ternary adaptable
   typedef A3 third_argument_type;  // imagined std:: ternary adaptable
   template <class P1, class P2, class P3> struct sig : public fun_type<R> {};

   template <class F> struct result;
   template <class Me, class X, class Y, class Z>
   struct result<Me(X,Y,Z)> : public Type<R> {};
   template <class Me, class X, class Y>
   struct result<Me(X,Y)>  : public Type<R> {};
   template <class Me, class X>
   struct result<Me(X)> : public Type<R> {};
};

template <class A1, class A2, class R>
struct c_fun_type<A1, A2, R, impl::Void> 
      : public fun_type<R>, public i_am_monomorphic {
   typedef A1 first_argument_type;   // std:: binary adaptable
   typedef A2 second_argument_type;  // std:: binary adaptable
   template <class P1, class P2> struct sig : public fun_type<R> {};

   template <class F> struct result;
   template <class Me, class X, class Y>
   struct result<Me(X,Y)> :public Type<R> {};
   template <class Me, class X>
   struct result<Me(X)> :public Type<R> {};
};

template <class A1, class R>
struct c_fun_type<A1, R, impl::Void, impl::Void> 
      : public fun_type<R>, public i_am_monomorphic {
   typedef A1 first_argument_type;   // for uniformity
   typedef A1 argument_type;  // std:: unary adaptable
   template <class P1> struct sig : public fun_type<R> {};

   template <class F> struct result;
   template <class Me, class X>
   struct result<Me(X)> :public Type<R> {};
};

struct CallableWithoutArguments {};
struct WrongNumberOfSigArgs {};

template <class R>
struct c_fun_type<R, impl::Void, impl::Void, impl::Void> 
      : public CallableWithoutArguments, public fun_type<R>, 
        public i_am_monomorphic {
   template <class Dummy1=impl::Void, class Dummy2=impl::Void>
   struct sig : public fun_type<WrongNumberOfSigArgs> {};
   template <class Dummy>
   struct sig<impl::Void,Dummy> : public fun_type<R> {};
};

//////////////////////////////////////////////////////////////////////
// Shorthand helpers
//////////////////////////////////////////////////////////////////////
// RT<F, args> means "return type of F when passed argument types <args>"

template <class T, class A1 = impl::Void, 
          class A2 = impl::Void, class A3 = impl::Void>
struct RT {
   typedef typename T::template sig<A1, A2, A3>::result_type result_type;
};

template <class T, class A1, class A2>
struct RT<T, A1, A2, impl::Void> {
   typedef typename T::template sig<A1, A2>::result_type result_type;
};

template <class T, class A1>
struct RT<T, A1, impl::Void, impl::Void> {
   typedef typename T::template sig<A1>::result_type result_type;
};

template <class T>
struct RT<T, impl::Void, impl::Void, impl::Void> {
   typedef typename T::template sig<>::result_type result_type;
};

} // end namespace fcpp
} // end namespace boost

#endif
