// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"
using std::cout; using std::endl;
using namespace boost::fcpp;

#ifndef NUM
#define NUM 1000
#endif


struct Divisible : public c_fun_type<int,int,bool> {
   bool operator()( int x, int y ) const
   { return x%y==0; }
} divisible;

struct Factors : public c_fun_type<int,odd_list<int> > {
   odd_list<int> operator()( int x ) const {
      return filter( thunk2(divisible,x),
                     enum_from_to(1,x) );
   }
} factors;

struct Prime : public c_fun_type<int,bool> {
   bool operator()( int x ) const {
      return factors(x)==cons(1,cons(x,NIL));
   }
} prime;

struct Primes : public c_fun_type<int,odd_list<int> > {
   odd_list<int> operator()( int n ) const {
      return take( n, filter( prime, enum_from(1) ) );
   }
} primes;


#ifdef REAL_TIMING
#  include "timer.h"
#else
struct Timer { int ms_since_start() { return 0; } };
#endif

int main() {
   Timer timer;
   cout << "Num primes = " << NUM << endl;
   int start = timer.ms_since_start();
      list<int> l = primes(NUM);
      cout << at( l, NUM-1 ) << endl;
   int end = timer.ms_since_start();
   cout << "took " << end-start << " ms" << endl;
   cout << endl;
}

