// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"
using std::endl;
using std::cout;
using namespace boost::fcpp;

int main() {
   // These will die unless FCPP_DEBUG
   list<int> l;
   try {
      head(l);
   }
   catch( fcpp_exception& e ) {
      cout << e.what() << endl;
   }
   try {
      tail(l);
   }
   catch( fcpp_exception& e ) {
      cout << e.what() << endl;
   }

   odd_list<int> m;
   try {
      head(m);
   }
   catch( fcpp_exception& e ) {
      cout << e.what() << endl;
   }
   try {
      tail(m);
   }
   catch( fcpp_exception& e ) {
      cout << e.what() << endl;
   }

   list<int> huge = enum_from_to(1,200000);
   length(huge);
   // likely to blow stack unless FCPP_SAFE_LIST
}

