// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#define BOOST_FCPP_ENABLE_LAMBDA
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

int main() {
   strict_list<int> empty;
   strict_list<int> l = cons(1,cons(2,cons(3,empty)));
   l = map( plus(1), l );
   l = cat(l,l);
   strict_list<strict_list<int> > llempty;
   strict_list<strict_list<int> > ll = cons(l,llempty);
   l = concat(ll);
   map( out_stream(&cout), l );
   cout << endl;
   //////////////////////////////////////////////////////////////////////
   lambda_var<1> X;
   l = lambda()[ comp_m<strict_list_m>()[ X | X <= l ] ]();
   map( out_stream(&cout), l );
   cout << endl;
   l = lambda()[ comp_m<strict_list_m>()[ X | X <= l, guard[X%less%4] ] ]();
   map( out_stream(&cout), l );
   cout << endl;
}
