// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "ref_count.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

// A <-- B      X <-- Y

struct A {
   int x;
   A( int y ) : x(y) {}
   virtual void f() const { cout << x << " A::f()" << endl; }
   virtual ~A()           { cout << x << " A's destructor" << endl; }
};

struct B : public A {
   B( int y ) : A(y) {}
   void f() const { cout << x << " B::f()" << endl; }
   ~B()           { cout << x << " B's destructor" << endl; }
};

int main() {
   boost::shared_ptr<A> a;
   {
      boost::shared_ptr<B> b( new B(2) );
      a = b;
      //b = a;     // illegal
   }
   a->f();
   boost::shared_ptr<B> b2 = boost::dynamic_pointer_cast<B>( a );
   b2->f();

   cout << "----------------" << endl;

   a = boost::shared_ptr<A>( new A(1) );
   a->f();
   b2->f();

   cout << "----------------" << endl;

   b2 = boost::dynamic_pointer_cast<B>( a );
   if( !b2 ) {
      cout << "Good, should be NULL, and #2 should be dead already" << endl;
   }

   return 0;
}
