// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <vector>
#include <algorithm>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

bool prime( int x ) {
   if( x<2 ) return false;
   for( int i=2; i<x; ++i )
      if( x%i == 0 )
         return false;
   return true;
}

void print( list<int> l ) {
   while( !null(l) ) {
      cout << head(l) << ' ';
      l = tail(l);
   }
   cout << endl;
}

template <class F>
void f( F x ) {
   cout << "sums are:" << endl;
   print( x(plus) );
   cout << "differences are:" << endl;
   print( x(minus) );
   cout << "products are:" << endl;
   print( x(multiplies) );
}

int main() {
   list<int> integers = enum_from(1);
   list<int> primesTo1000 = filter( ptr_to_fun(&prime), take(1000,integers) );
   list<int> primesBetween100and120 = 
      filter( compose2( logical_and, greater(_,100), less(_,120) ), 
              primesTo1000 );
   print( primesBetween100and120 );

   cout << until(ptr_to_fun(&prime),inc,114) << endl;  // first prime from 114

   list<int> l = list_with<>()( 1, 4, 7, 3 );
   print( scanl1(plus,l) );

   list<int> m = list_with<>()( 4, 5, 6 );
   list<int> n = list_with<>()( 1, 2, 3 );
   f( zip_with(_,m,n) );

   int a[5] = { 1, 2, 3, 4, 5 };
   std::vector<int> v( a, a+5 );
   std::transform( v.begin(), v.end(), v.begin(), plus(3) );
   std::copy( v.begin(), v.end(), std::ostream_iterator<int>(std::cout," ") );
   std::cout << std::endl;
}
