// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <iomanip>
using std::cout;
using std::endl;
using std::cin;

#define BOOST_FCPP_ENABLE_LAMBDA
#include "prelude.hpp"
using namespace boost::fcpp;

// Tests all named operators, infix syntax, etc.

struct Animal {
   virtual void speak() = 0;
   virtual ~Animal() {}
};

struct Dog : public Animal {
   void speak() { cout << "Woof!" << endl; }
};

int main() {
   int *p = new1<int>()( 5 );
   cout << dereference( address_of( *p ) ) << endl;
   delete_(p);   
   cout << (2 ^plus^ 3) << endl;
   cout << (6 ^minus^ 1) << endl;
   cout << (5 ^multiplies^ 1) << endl;
   cout << (10 ^divides^ 2) << endl;
   cout << (19 ^modulus^ 7) << endl;
   cout << "-----------------------------------" << endl;
   cout << (1 ^less^ 2) << endl;
   cout << (1 ^less_equal^ 1) << endl;
   cout << (2 ^greater^ 1) << endl;
   cout << (2 ^greater_equal^ 2) << endl;
   cout << (2 ^equal^ 2) << endl;
   cout << (2 ^not_equal^ 3) << endl;
   cout << logical_not( false ^logical_and^ true ) << endl;
   cout << logical_not( false ^logical_or^ false ) << endl;
   cout << "-----------------------------------" << endl;
   cout << construct1<float>()(5) << endl;
   cout << "-----------------------------------" << endl;
   Animal *a = new0<Dog>()();
   ptr_to_fun( &Animal::speak )( a );
   ptr_to_fun( &Animal::speak )( dynamic_cast_<Dog*>()(a) );
   cout << "-----------------------------------" << endl;
   &cout ^out_stream^ 5 ^out_stream^ make_manip(cout)(endl);
   &cout ^out_stream^ "The answer is " ^out_stream^ 5 
      ^out_stream^ make_manip(cout)(endl);
   const char* s = "X is ";
   lambda_var<1> X;
   lambda(X)[ &cout %out_stream% s %out_stream% X 
              %out_stream% make_manip(cout)(endl) ](5);
   fun1<int,std::ostream*> f = lambda(X)[ &cout %out_stream% s %out_stream% X 
              %out_stream% make_manip(cout)(endl) ];
   f(5);
   s = "17(hex) is ";
   &cout ^out_stream^ s ^out_stream^ make_manip(cout)(std::hex) 
         ^out_stream^ 17 ^out_stream^ make_manip(cout)(endl);
   cout << "-----------------------------------" << endl;
   int x;
   cout << "Enter a number: " << endl;
   &cin ^in_stream^ &x;
   cout << "You said " << x << endl;
}
