// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

void print( list<int> l ) {
   while( !null(l) ) {
      cout << head(l) << ' ';
      l = tail(l);
   }
   cout << endl;
}

int main() {
   // Create the list 1..5
   list<int> integers = take( 5, enum_from(1) );

   print( integers );

   // These two do the same thing (2..6)
   print( map( inc, integers ) );
   print( map( plus(1), integers ) );

   // These two do the same thing (3..7)
   print( map( compose(inc,inc), integers ) );
   print( map( plus(2), integers ) );

   // These three do the same thing (0..-4)
   print( map( bind1of2(minus,1), integers ) );
   print( map( minus(1), integers ) );
   print( map( minus(1,_), integers ) );

   // These two do the same thing (0..4)
   print( map( bind2of2(minus,1), integers ) );
   print( map( minus(_,1), integers ) );

   // of_type course, map() is curryable too...
   print( map( plus(2) )( integers ) );
   print( map( _, integers )( plus(2) ) );
}
