// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

bool prime( int x ) {
   if( x<2 ) return false;
   for( int i=2; i<x; i++ )
      if( x%i == 0 )
         return false;
   return true;
}

void print( list<int> l ) {
   while( !null(l) ) {
      cout << head(l) << ' ';
      l = tail(l);
   }
   cout << endl;
}

int main() {
   list<int> integers = enum_from(1);
   print( take(5,integers) );

   list<int> evens = filter( even, integers );
   print( take(5,evens) );

   list<int> primes = filter( ptr_to_fun(&prime), integers );
   print( take(5,primes) );

}
