// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

// Tests list<T> where T has no default constructor

class Foo {
   Foo();
public:
   int x;
   Foo(int y) : x(y) { std::cout << "Foo(" << x << ")" << std::endl; }
};

int main() {
   std::cout << "a" << std::endl;
   list<Foo> l;
   std::cout << "a" << std::endl;
   l = cons( Foo(1), cons( Foo(2), NIL ) );
   std::cout << "a" << std::endl;
   l = tail(l);
   std::cout << "a" << std::endl;
   head(l);
}
