// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <string>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::string;
using std::cout;
using std::endl;

struct Foo {
   template <class F>
   struct sig : public fun_type<typename F::result_type> {};

   template <class F>
   typename F::result_type operator()( const F& f ) const {
      typedef typename F::result_type T;
      T x = T();
      return f(x);
   }
} foo;

int main() {
   string y = "yadda:";
   fun1<bool,bool> n = logical_not;
   fun1<int,int> i = inc;
   fun1<string,string> s = boost::fcpp::plus(y);

   cout << foo(n) << endl;     // true
   cout << foo(i) << endl;     // 1
   cout << foo(s) << endl;     // "yadda:"
}
