// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include "prelude.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

class Counter {
   int x;
public:
   Counter() : x(0) {}
   void increment() { x++; }
   int value() const { return x; }
};

int main() {
   Counter a, b;
   cout << a.value() << " " << b.value() << endl;
   a.increment();
   a.increment();
   b.increment();
   cout << a.value() << " " << b.value() << endl;
}

