// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
#include <typeinfo>
#include "prelude.hpp"
#include "boost/test/minimal.hpp"

using namespace boost::fcpp;

using std::cout;
using std::endl;

int test_main(int,char**) {
   using boost::fcpp::greater;
   using boost::fcpp::minus;
   using boost::fcpp::plus;

   BOOST_CHECK( minus(7,4) == 3 );
   BOOST_CHECK( minus(7)(4) == 3 );

   BOOST_CHECK( minus(_,4)(7) == 3 );
   BOOST_CHECK( minus(7,_)(4) == 3 );

   BOOST_CHECK( until( greater(_,9), inc, 1 ) == 10 );
   BOOST_CHECK( until( greater(_,9), inc )(1) == 10 );
   BOOST_CHECK( until( greater(_,9) )(inc,1) == 10 );

   BOOST_CHECK( until( _, inc, _ )( greater(_,9), 1) == 10 );
   BOOST_CHECK( until( _, inc )( greater(_,9), 1) == 10 );
   BOOST_CHECK( until( _, _, 1 )( greater(_,9), inc) == 10 );
   BOOST_CHECK( until( greater(_,9), _, _ )(inc,1) == 10 );

   BOOST_CHECK( until( _, inc, 1 )(greater(_,9)) == 10 );
   BOOST_CHECK( until( greater(_,9), _, 1 )(inc) == 10 );
   BOOST_CHECK( until( greater(_,9), inc, _ )(1) == 10 );


   BOOST_CHECK( until( greater(_,9) )(inc)(1) == 10 );
   BOOST_CHECK( until( greater(_,9), _ )(inc)(1) == 10 );
   BOOST_CHECK( until( greater(_,9), _, _ )(inc)(1) == 10 );

   BOOST_CHECK( until( _, inc, _ )(greater(_,9) )(1) == 10 );
   BOOST_CHECK( until( _, _, 1 )(greater(_,9) )(inc) == 10 );

   BOOST_CHECK( until( less(_,1), dec, 9 ) == 0 );


   fun2<int,int,int> f = minus;  

   
   BOOST_CHECK( f(_,4)(5) == 1 );
   fun1<int,int> sub4 = f(_,4);
   BOOST_CHECK( sub4(5) == 1 );

   fun1<int,int> decrement = minus(_,1);
   fun1<int,int> in = inc;
   BOOST_CHECK( decrement(9) == in(7) );

   fun2<int,int,int> z = minus;
   BOOST_CHECK( z(7,1) == 6 );
   BOOST_CHECK( z(7,_)(1) == 6 );
   BOOST_CHECK( minus(7,_)(1) == 6 );

   BOOST_CHECK( h_uncurry(plus)( make_pair(3,4) ) == 7 );
   BOOST_CHECK( h_curry(h_uncurry(plus))(3,4) == 7 );
   return 0;
}

