// Copyright Brian McNamara and Yannis Smaragdakis 2000-2003.
// Use, modification and distribution is subject to the
// Boost Software License, Version 1.0.  (See accompanying file
// LICENSE_1_0.txt or copy at http://www.boost.org/LICENSE_1_0.txt)

#include <iostream>
using std::cout;
using std::endl;

#include <string>
using std::string;

#define BOOST_FCPP_ENABLE_LAMBDA
#include "prelude.hpp"

using namespace boost::fcpp;

typedef string S;
void print( S s ) {
   cout << s << endl;
}

int main() {
   int x = 3;
   int y = 4;
   int z = x ^plus^ y;
   cout << z << endl;

   fun0<void> hello = thunk1( ptr_to_fun(&print), S("hello") );
   cout << "-------" << endl;
   by_need<int> xt( before( hello, const_(3) ) );
   by_need<int> yt( 4 );
   lambda_var<1> X;
   lambda_var<2> Y;
   cout << "-------" << endl;
   by_need<int> zt = lambda()[ xt %bind% lambda(X)[
                               yt %bind% lambda(Y)[
                               unit_m<by_need_m>()[ X %plus% Y ] ] ] ]();
   cout << "-------" << endl;
   cout << zt.force() << endl;
   cout << zt.force() << endl;
   cout << "-------" << endl;
   xt = by_need<int>( before( hello, const_(3) ) );
   zt = lambda()[ comp_m<by_need_m>()[ X %plus% Y | X<=xt, Y<=yt ] ] ();
   cout << "-------" << endl;
   cout << zt.force() << endl;
   cout << zt.force() << endl;

   {
      cout << "-------------------" << endl;
      // expensive negate
      fun1<int,int> exp_neg = 
         before( thunk1( ptr_to_fun(&print), S("expensive") ), negate );
      int z = plus( exp_neg(3), 4 );
      cout << z << endl;
   
      cout << "-------" << endl;
      by_need<int> bx( 3 );
      by_need<int> by( 4 );
      by_need<int> bz( lift_m2<by_need_m>()(plus)
                         ( lift_m<by_need_m>()(exp_neg)(bx), by ) );
      cout << "..." << endl;
      cout << bz.force() << endl;

      cout << "-------------------" << endl;
      bz = by_need<int>( before( hello, const_(0) ) );
      cout << lift_m3<by_need_m>()(ignore(plus))(bz,bx,b_delay(4)).force() 
                << endl;
   }

   {
      cout << "==========" << endl;
      fun1<int,int> p = before( hello, plus(1) );
      zt = lambda()[ comp_m<by_need_m>()[ X %plus% Y | 
                                       X<=b_lift(p)[3], Y<=yt ] ] ();
                                       //X<=b_delay[p[3]], Y<=yt ] ] ();
      cout << "==========" << endl;
      cout << zt.force() << endl;
      cout << zt.force() << endl;
      cout << "==========" << endl;

      fun2<int,int,int> p2 = before( hello, plus );
      zt = lambda()[ comp_m<by_need_m>()[ X | X<=b_lift(p2)[3][4] ] ] ();
      cout << "==========" << endl;
      cout << zt.force() << endl;
      cout << zt.force() << endl;
      cout << "==========" << endl;

      fun3<int,int,int,int> p3 = before( hello, ignore(plus) );
      zt = lambda()[ comp_m<by_need_m>()[ X | X<=b_lift(p3)[1][3][4] ] ] ();
      cout << "==========" << endl;
      cout << zt.force() << endl;
      cout << zt.force() << endl;
      cout << "==========" << endl;

      fun0<int> p0 = before( hello, thunk2(plus,3,4) );
      zt = lambda()[ comp_m<by_need_m>()[ X | X<=b_lift(p0)[_*_] ] ] ();
      cout << "==========" << endl;
      cout << zt.force() << endl;
      cout << zt.force() << endl;
      cout << "==========" << endl;
   }
}
