(******************************************************************************)
(*									      *)
(*	Dr. William T. Verts (C) April 2, 1996				      *)
(*									      *)
(*	This Pascal unit contains a number of type and procedure definitions  *)
(*	for use by Amherst College CS32 students, directly or as reference,   *)
(*	however they see fit.						      *)
(*									      *)
(******************************************************************************)

Unit Standard ;

Interface

Const	Zero		= 0 ;
	Blank		= ' ' ;
	Quote		= '''' ;
	DQuote		= '"' ;
	Pi		= 3.14159265358979323846 ;

Type	Color		= Record
				Red	: Byte	;
				Green	: Byte	;
				Blue	: Byte	;
			  End ;

	Point_2D	= Record
				X	: Real	;
				Y	: Real	;
			  End ;

	Point_3D	= Record
				X	: Real ;
				Y	: Real ;
				Z	: Real ;
			  End ;

	Parametric	= Record
				Offset	: Real ;
				Scale	: Real ;
			  End ;

	Line_2D		= Record
				X	: Parametric ;
				Y	: Parametric ;
			  End ;

	Line_3D		= Record
				X	: Parametric ;
				Y	: Parametric ;
				Z	: Parametric ;
			  End ;

	Vector3		= Array [1..3] Of Real ;
	Matrix3		= Array [1..3, 1..3] Of Real ;

Function  Letter_ORD	(CH:Char) : Integer ;
Function  Radians	(Degrees:Real) : Real ;
Function  Degrees	(Radians:Real) : Real ;
Function  Maximum	(M,N:Real) : Real ;
Function  Minimum	(M,N:Real) : Real ;
Function  Greater	(M,N:LongInt) : LongInt ;
Function  Lesser	(M,N:LongInt) : LongInt ;
Function  IFi		(B:Boolean ; M,N:LongInt) : LongInt ;
Function  IFr		(B:Boolean ; M,N:Real) : Real ;
Procedure iSwap		(Var M,N:LongInt) ;
Procedure rSwap		(Var M,N:Real) ;

Function  Length_XY	(X1,Y1,X2,Y2:Real) : Real ;
Function  Length_XYZ	(X1,Y1,Z1,X2,Y2,Z2:Real) : Real ;
Function  Length_2D	(P1,P2:Point_2D) : Real ;
Function  Length_3D	(P1,P2:Point_3D) : Real ;
Function  Length_Vector	(V1,V2:Vector3) : Real ;

Function  Get_Value	(P:Parametric ; T:Real) : Real ;
Procedure Get_Parametric(Var Result:Parametric ; P1,P2:Real) ;
Procedure Get_Line_3D	(Var Result:Line_3D    ; P1,P2:Point_3D) ;
Procedure Get_Line_2D	(Var Result:Line_2D    ; P1,P2:Point_2D) ;
Procedure Get_Point_3D	(Var Result:Point_3D   ; L:Line_3D ; T:Real) ;
Procedure Get_Point_2D	(Var Result:Point_2D   ; L:Line_2D ; T:Real) ;
Procedure Get_Normal_2D	(Var Result:Line_2D    ; L:Line_2D ; P:Point_2D) ;

Procedure Identity	(Var Result:Matrix3) ;
Procedure Translate	(Var Result:Matrix3 ; Tx,Ty:Real) ;
Procedure Scale		(Var Result:Matrix3 ; Sx,Sy:Real) ;
Procedure Rotate	(Var Result:Matrix3 ; Radians:Real) ;
Procedure Multiply	(Var Result:Matrix3 ; M1,M2:Matrix3) ;
Procedure Transform	(Var Result:Vector3 ; M:Matrix3 ; V:Vector3) ;

(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

Implementation

(******************************************************************************)
(* Utility routines							      *)
(******************************************************************************)
(*----------------------------------------------------------------------------*)
(* Convert a letter into an integer, where 'a' & 'A' = 1, 'b' & 'B' = 2, etc. *)
(*----------------------------------------------------------------------------*)

Function  Letter_ORD (CH:Char) : Integer ;
Begin	(***)
	If CH In ['A'..'Z'] Then Letter_ORD := Ord(CH) - Ord('A') Else
	If CH In ['a'..'z'] Then Letter_ORD := Ord(CH) - Ord('a') Else
				 Letter_ORD := Zero ;
End ;

(*----------------------------------------------------------------------------*)
(* Convert angle from degree measure [0..360] into radian measure [0..2pi]    *)
(*----------------------------------------------------------------------------*)

Function Radians (Degrees:Real) : Real ;
Begin	(***)
	Radians := Degrees / 180.0 * Pi ;
End ;

(*----------------------------------------------------------------------------*)
(* Convert angle from radian measure [0..2pi] into degree measure [0..360]    *)
(*----------------------------------------------------------------------------*)

Function Degrees (Radians:Real) : Real ;
Begin	(***)
	Degrees := Radians / Pi * 180.0 ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the maximum of the two real arguments				      *)
(*----------------------------------------------------------------------------*)

Function  Maximum (M,N:Real) : Real ;
Begin	(***)
	If M > N Then Maximum := M
		 Else Maximum := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the minimum of the two real arguments				      *)
(*----------------------------------------------------------------------------*)

Function  Minimum (M,N:Real) : Real ;
Begin	(***)
	If M < N Then Minimum := M
		 Else Minimum := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the maximum of the two integer arguments			      *)
(*----------------------------------------------------------------------------*)

Function  Greater (M,N:LongInt) : LongInt ;
Begin	(***)
	If M > N Then Greater := M
		 Else Greater := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the minimum of the two integer arguments			      *)
(*----------------------------------------------------------------------------*)

Function  Lesser (M,N:LongInt) : LongInt ;
Begin	(***)
	If M < N Then Lesser := M
		 Else Lesser := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the 1st argument if B is true, the second if B is false (integer)   *)
(*----------------------------------------------------------------------------*)

Function IFi (B:Boolean ; M,N:LongInt) : LongInt ;
Begin	(***)
	If B Then IFi := M Else IFi := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the 1st argument if B is true, the second if B is false (real)      *)
(*----------------------------------------------------------------------------*)

Function IFr (B:Boolean ; M,N:Real) : Real ;
Begin	(***)
	If B Then IFr := M Else IFr := N ;
End ;

(*----------------------------------------------------------------------------*)
(* Exchange the two integer arguments					      *)
(*----------------------------------------------------------------------------*)

Procedure iSwap (Var M,N:LongInt) ;
    Var	Temp : LongInt ;
Begin	(***)
	Temp	:= M ;
	M	:= N ;
	N	:= Temp ;
End ;

(*----------------------------------------------------------------------------*)
(* Exchange the two real arguments					      *)
(*----------------------------------------------------------------------------*)

Procedure rSwap (Var M,N:Real) ;
    Var	Temp : Real ;
Begin	(***)
	Temp	:= M ;
	M	:= N ;
	N	:= Temp ;
End ;

(******************************************************************************)
(* Euclidean Length routines						      *)
(******************************************************************************)
(*----------------------------------------------------------------------------*)
(* Return the distance between 2D points <X1,Y1> and <X2,Y2>		      *)
(*----------------------------------------------------------------------------*)

Function  Length_XY	(X1,Y1,X2,Y2:Real) : Real ;
    Var	Min	: Real ;
	Max	: Real ;
Begin	(***)
	Min	:= Abs(X2 - X1) ;
	Max	:= Abs(Y2 - Y1) ;
	If Min > Max Then rSwap(Min, Max) ;

	If Max <= Zero Then Length_XY := 0.0
		       Else Length_XY := Max * Sqrt(1.0 + Sqr(Min/Max)) ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the distance between 3D points <X1,Y1,Z1> and <X2,Y2,Z2>	      *)
(*----------------------------------------------------------------------------*)

Function  Length_XYZ	(X1,Y1,Z1,X2,Y2,Z2:Real) : Real ;
Begin	(***)
	Length_XYZ := Sqrt(Sqr(X2-X1) + Sqr(Y2-Y1) + Sqr(Z2-Z1)) ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the distance between 2D points P1 and P2			      *)
(*----------------------------------------------------------------------------*)

Function Length_2D (P1,P2:Point_2D) : Real ;
Begin	(***)
	Length_2D := Length_XY(P1.X, P1.Y, P2.X, P2.Y) ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the distance between 3D points P1 and P2			      *)
(*----------------------------------------------------------------------------*)

Function Length_3D (P1,P2:Point_3D) : Real ;
Begin	(***)
	Length_3D := Length_XYZ(P1.X, P1.Y, P1.Z, P2.X, P2.Y, P2.Z) ;
End ;

(*----------------------------------------------------------------------------*)
(* Return the distance between vectors V1 and V2, but where the Vector3 type  *)
(* is treated as a homogeneous coordinate in 2D (3rd array element ignored)   *)
(*----------------------------------------------------------------------------*)

Function  Length_Vector	(V1,V2:Vector3) : Real ;
Begin	(***)
	Length_Vector := Length_XY(V1[1], V1[2], V2[1], V2[2]) ;
End ;

(******************************************************************************)
(* Parametric line and point routines					      *)
(******************************************************************************)
(*----------------------------------------------------------------------------*)
(* Compute the value along a 1D parametric (used in groups for 2D and 3D)     *)
(*----------------------------------------------------------------------------*)

Function Get_Value (P:Parametric ; T:Real) : Real ;
Begin	(***)
	Get_Value := (P.Scale * T) + P.Offset ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a 1D parametric given two valid values along the 1D "line"	      *)
(*----------------------------------------------------------------------------*)

Procedure Get_Parametric (Var Result:Parametric ; P1,P2:Real) ;
Begin	(***)
	Result.Offset	:= P1 ;
	Result.Scale	:= (P2 - P1) ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a 3D line from two 3D points (build 3 parametrics)		      *)
(*----------------------------------------------------------------------------*)

Procedure Get_Line_3D (Var Result:Line_3D ; P1,P2:Point_3D) ;
Begin	(***)
	Get_Parametric (Result.X, P1.X, P2.X) ;
	Get_Parametric (Result.Y, P1.Y, P2.Y) ;
	Get_Parametric (Result.Z, P1.Z, P2.Z) ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a 2D line from two 2D points (build 2 parametrics)		      *)
(*----------------------------------------------------------------------------*)

Procedure Get_Line_2D (Var Result:Line_2D ; P1,P2:Point_2D) ;
Begin   (***)
	Get_Parametric (Result.X, P1.X, P2.X) ;
	Get_Parametric (Result.Y, P1.Y, P2.Y) ;
End ;

(*----------------------------------------------------------------------------*)
(* Given a 3D parametric line, find the 3D point corresponding to parameter T *)
(*----------------------------------------------------------------------------*)

Procedure Get_Point_3D (Var Result:Point_3D ; L:Line_3D ; T:Real) ;
Begin	(***)
	Result.X := Get_Value(L.X, T) ;
	Result.Y := Get_Value(L.Y, T) ;
	Result.Z := Get_Value(L.Z, T) ;
End ;

(*----------------------------------------------------------------------------*)
(* Given a 2D parametric line, find the 2D point corresponding to parameter T *)
(*----------------------------------------------------------------------------*)

Procedure Get_Point_2D (Var Result:Point_2D ; L:Line_2D ; T:Real) ;
Begin	(***)
	Result.X := Get_Value(L.X, T) ;
	Result.Y := Get_Value(L.Y, T) ;
End ;

(*----------------------------------------------------------------------------*)
(* Return a 2D line which passes through 2D point and is normal to given line *)
(*----------------------------------------------------------------------------*)

Procedure Get_Normal_2D (Var Result:Line_2D ; L:Line_2D ; P:Point_2D) ;
Begin	(***)
	Result.X.Offset := P.X ;
	Result.X.Scale  := -L.Y.Scale ;
	Result.Y.Offset := P.Y ;
	Result.Y.Scale  := +L.X.Scale ;
End ;

(******************************************************************************)
(* 3x3 Matrix and 3 element Vector routines				      *)
(******************************************************************************)
(*----------------------------------------------------------------------------*)
(* Return an identity matrix (zeros everywhere except ones along the diagonal *)
(*----------------------------------------------------------------------------*)

Procedure Identity (Var Result:Matrix3) ;

    Var	I, J	: Integer ;

Begin	(***)
	For I := 1 To 3 Do
		For J := 1 To 3 Do
			Result[I,J] := Ord(I=J) ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a matrix for translating a point by <Tx,Ty>			      *)
(*----------------------------------------------------------------------------*)

Procedure Translate (Var Result:Matrix3 ; Tx,Ty:Real) ;
Begin	(***)
	Identity (Result) ;
	Result[1,3] := Tx ;
	Result[2,3] := Ty ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a matrix for scaling a point by <Sx,Sy>			      *)
(*----------------------------------------------------------------------------*)

Procedure Scale (Var Result:Matrix3 ; Sx,Sy:Real) ;
Begin	(***)
	Identity (Result) ;
	ResUlt[1,1] := Sx ;
	Result[2,2] := Sy ;
End ;

(*----------------------------------------------------------------------------*)
(* Create a matrix for rotating a point around the origin by a given angle    *)
(*----------------------------------------------------------------------------*)

Procedure Rotate (Var Result:Matrix3 ; Radians:Real) ;

    Var	Sine	: Real ;
	Cosine	: Real ;

Begin	(***)
	Sine	:= Sin(Radians) ;
	Cosine	:= Cos(Radians) ;
	Identity (Result) ;
	Result[1,1] :=  Cosine ;
	Result[1,2] := -Sine ;
	Result[2,1] :=  Sine ;
	Result[2,2] :=  Cosine ;
End ;

(*----------------------------------------------------------------------------*)
(* Multiply two matrices together to create a third matrix		      *)
(*----------------------------------------------------------------------------*)

Procedure Multiply (Var Result:Matrix3 ; M1,M2:Matrix3) ;

    Var	I, J, K	: Integer ;
	Temp	: Real ;

Begin	(***)
	For I := 1 To 3 Do
		For J := 1 To 3 Do
			Begin	(***)
				Temp := 0.0 ;
				For K := 1 To 3 Do
					Temp := Temp + (M1[I,K] * M2[K,J]) ;
				Result[I,J] := Temp ;
			End ;
End ;

(*----------------------------------------------------------------------------*)
(* Multiply a matrix times a vector to create a new vector (transform a point)*)
(*----------------------------------------------------------------------------*)

Procedure Transform (Var Result:Vector3 ; M:Matrix3 ; V:Vector3) ;

    Var	I, J	: Integer ;
	Temp	: Real ;

Begin	(***)
	For I := 1 To 3 Do
		Begin	(***)
			Temp := 0.0 ;
			For J := 1 To 3 Do Temp := Temp + (M[I,J] * V[J]) ;
			Result[I] := Temp ;
		End ;
End ;

(******************************************************************************)

End.
