(******************************************************************************)
(*									      *)
(*	Dr. William T. Verts (C) March 27, 1996				      *)
(*									      *)
(*	Stack of Integers Unit using linked list representation		      *)
(*	Standard Version						      *)
(*									      *)
(******************************************************************************)

Unit Stacks2a ;

Interface

Const	Zero	= 0 ;

Type	Link	= ^Node ;

	Node	= Record
			Value	: Integer ;
			Next	: Link ;
		  End ;

	Stack   = Link ;

Procedure Stack_Init	(Var S:Stack) ;
Procedure Stack_Done	(Var S:Stack) ;
Procedure Stack_Clear	(Var S:Stack) ;
Function  Stack_Is_Empty(Var S:Stack) : Boolean ;
Function  Stack_Is_Full	(Var S:Stack) : Boolean ;
Function  Stack_Top	(Var S:Stack) : Integer ;
Function  Stack_Pop	(Var S:Stack) : Integer ;
Procedure Stack_Push	(Var S:Stack ; N:Integer) ;

(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

Implementation

Procedure Stack_Init (Var S:Stack) ;
Begin	(***)
	S := Nil ;
End ;

Procedure Stack_Done (Var S:Stack) ;
Begin	(***)
	Stack_Clear(S) ;
End ;

Procedure Stack_Clear (Var S:Stack) ;
    Var	N : Integer ;
Begin	(***)
	While Not Stack_Is_Empty(S) Do N := Stack_Pop(S) ;
End ;

Function Stack_Is_Empty (Var S:Stack) : Boolean ;
Begin	(***)
	Stack_Is_Empty := (S = Nil) ;
End ;

Function Stack_Is_Full (Var S:Stack) : Boolean ;
Begin	(***)
	Stack_Is_Full := (MemAvail < SizeOf(Node)) ;  (* TURBO Specific *)
End ;

Function Stack_Top (Var S:Stack) : Integer ;
Begin	(***)
	If Stack_Is_Empty(S) Then Stack_Top := Zero
			     Else Stack_Top := S^.Value ;
End ;

Function Stack_Pop (Var S:Stack) : Integer ;
    Var	P : Link ;
Begin	(***)
	Stack_Pop	:= Stack_Top(S) ;
	If Not Stack_Is_Empty(S) Then
		Begin	(***)
			P	:= S ;
			S	:= S^.Next ;
			P^.Next	:= Nil ;
			P^.Value:= Zero ;
			Dispose	(P) ;
		End ;
End ;

Procedure Stack_Push  (Var S:Stack ; N:Integer) ;
    Var	P : Link ;
Begin	(***)
	If Not Stack_Is_Full(S) Then
		Begin	(***)
			New	(P) ;
			P^.Value:= N ;
			P^.Next	:= S ;
			S	:= P ;
		End ;
End ;

End.
