(******************************************************************************)
(*									      *)
(*	Dr. William T. Verts (C) March 27, 1996				      *)
(*									      *)
(*	Stack of Integers Unit using linked list representation		      *)
(*	Object Oriented Version						      *)
(*									      *)
(******************************************************************************)

Unit Stacks2 ;

Interface

Const	Zero	= 0 ;

Type	Link	= ^Node ;

	Node	= Record
			Value	: Integer ;
			Next	: Link ;
		  End ;

        Stack   = Object
			Constructor     Init ;
                        Destructor      Done ; Virtual ;
                        Procedure       Clear ;
                        Function        Is_Empty : Boolean ;
                        Function        Is_Full : Boolean ;
                        Function        Top : Integer ;
                        Function        Pop : Integer ;
			Procedure       Push (N:Integer) ;
                  Private
			Data		: Link ;
		  End ;

(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

Implementation

Constructor Stack.Init ;
Begin	(***)
	Data	:= Nil ;
End ;

Destructor Stack.Done ;
Begin	(***)
	Clear ;
End ;

Procedure Stack.Clear ;
    Var	N : Integer ;
Begin	(***)
	While Not Is_Empty Do N := Pop ;
End ;

Function Stack.Is_Empty : Boolean ;
Begin	(***)
	Is_Empty := (Data = Nil) ;
End ;

Function Stack.Is_Full : Boolean ;
Begin	(***)
	Is_Full := (MemAvail < SizeOf(Node)) ;  (* TURBO Specific *)
End ;

Function Stack.Top : Integer ;
Begin	(***)
	If Is_Empty Then Top := Zero
		    Else Top := Data^.Value ;
End ;

Function Stack.Pop : Integer ;
    Var	P : Link ;
Begin	(***)
	Pop	:= Top ;
	If Not Is_Empty Then
		Begin	(***)
			P	:= Data ;
			Data	:= Data^.Next ;
			P^.Next	:= Nil ;
			P^.Value:= Zero ;
			Dispose	(P) ;
		End ;
End ;

Procedure Stack.Push (N:Integer) ;
    Var	P : Link ;
Begin	(***)
	If Not Is_Full Then
		Begin	(***)
			New	(P) ;
			P^.Value:= N ;
			P^.Next	:= Data ;
			Data	:= P ;
		End ;
End ;

End.
