(******************************************************************************)
(*									      *)
(*	Dr. William T. Verts (C) March 27, 1996				      *)
(*									      *)
(*	Stack of Integers Unit using array representation		      *)
(*	Standard Version						      *)
(*									      *)
(******************************************************************************)

Unit Stacks1a ;

Interface

Const	Zero	= 0 ;
	Limit	= 100 ;

Type	Range	= 1..Limit ;
	Count	= 0..Limit ;
	Buffer	= Array [Range] Of Integer ;

	Stack	= Record
			Table		: Buffer ;
			Top_Index	: Count ;
		  End ;

Procedure Stack_Init	(Var S:Stack) ;
Procedure Stack_Done	(Var S:Stack) ;
Procedure Stack_Clear	(Var S:Stack) ;
Function  Stack_Is_Empty(Var S:Stack) : Boolean ;
Function  Stack_Is_Full	(Var S:Stack) : Boolean ;
Function  Stack_Top	(Var S:Stack) : Integer ;
Function  Stack_Pop	(Var S:Stack) : Integer ;
Procedure Stack_Push	(Var S:Stack ; N:Integer) ;

(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

Implementation

Procedure Stack_Init (Var S:Stack) ;
Begin	(***)
	S.Top_Index := Zero ;
End ;

Procedure Stack_Done (Var S:Stack) ;
Begin	(***)
	Stack_Clear (S) ;
End ;

Procedure Stack_Clear (Var S:Stack) ;
    Var	N : Integer ;
Begin	(***)
	While Not Stack_Is_Empty(S) Do N := Stack_Pop(S) ;
End ;

Function Stack_Is_Empty (Var S:Stack) : Boolean ;
Begin	(***)
	Stack_Is_Empty := (S.Top_Index = Zero) ;
End ;

Function Stack_Is_Full (Var S:Stack) : Boolean ;
Begin	(***)
	Stack_Is_Full := (S.Top_Index = Limit) ;
End ;

Function Stack_Top (Var S:Stack) : Integer ;
Begin	(***)
	If Stack_Is_Empty(S) Then Stack_Top := Zero
			     Else Stack_Top := S.Table[S.Top_Index] ;
End ;

Function Stack_Pop (Var S:Stack) : Integer ;
Begin	(***)
	Stack_Pop := Stack_Top(S) ;
	If Not Stack_Is_Empty(S) Then S.Top_Index := S.Top_Index - 1  ;
End ;

Procedure Stack_Push (Var S:Stack ; N:Integer) ;
Begin	(***)
	If Not Stack_Is_Full(S) Then
		Begin	(***)
			S.Top_Index := S.Top_Index + 1 ;
			S.Table[S.Top_Index] := N ;
		End ;
End ;

End.
