(******************************************************************************)
(*									      *)
(*	Dr. William T. Verts (C) March 27, 1996				      *)
(*									      *)
(*	Stack of Integers Unit using array representation		      *)
(*	Object Oriented Version						      *)
(*									      *)
(******************************************************************************)

Unit Stacks1 ;

Interface

Const	Zero	= 0 ;
	Limit	= 100 ;

Type	Range	= 1..Limit ;
	Count	= 0..Limit ;
	Buffer	= Array [Range] Of Integer ;

	Stack	= Object
			Constructor	Init ;
			Destructor	Done ; Virtual ;
			Procedure	Clear ;
			Function	Is_Empty : Boolean ;
			Function	Is_Full : Boolean ;
			Function	Top : Integer ;
			Function	Pop : Integer ;
			Procedure	Push (N:Integer) ;
		  Private
			Table		: Buffer ;
			Top_Index	: Count ;
		  End ;

(******************************************************************************)
(******************************************************************************)
(******************************************************************************)

Implementation

Constructor Stack.Init ;
Begin	(***)
	Top_Index := Zero ;
End ;

Destructor Stack.Done ;
Begin	(***)
	Clear ;
End ;

Procedure Stack.Clear ;
    Var	N : Integer ;
Begin	(***)
	While Not Is_Empty Do N := Pop ;
End ;

Function Stack.Is_Empty : Boolean ;
Begin	(***)
	Is_Empty := (Top_Index = Zero) ;
End ;

Function Stack.Is_Full : Boolean ;
Begin	(***)
	Is_Full := (Top_Index = Limit) ;
End ;

Function Stack.Top : Integer ;
Begin	(***)
	If Is_Empty Then Top := Zero
		    Else Top := Table[Top_Index] ;
End ;

Function Stack.Pop : Integer ;
Begin	(***)
	Pop := Top ;
	If Not Is_Empty Then Top_Index := Top_Index - 1  ;
End ;

Procedure Stack.Push (N:Integer) ;
Begin	(***)
	If Not Is_Full Then
		Begin	(***)
			Top_Index := Top_Index + 1 ;
			Table[Top_Index] := N ;
		End ;
End ;

End.
