%MATLAB FILE TO TEST THE FAST CLASSIFIER%
%Subhransu Maji (smaji@cs.berkeley.edu)

% demo code for using min kernel in svmtrain and fastpredict

% Uses random training and test data set. Expected error is
% close to 50%. Here however we are testing how close to the exact
% predictions we get using the approximations.



%
% create random training and test data
%
numtr = 1000;  % number of training examples
numte = 50000; % number of testing examples
dim = 100;     % data dimension
trd = rand(numtr,dim);         % training data
trl = (rand(numtr,1) > 0.5)+1; % training labels {1,2}
%test data%
ted = rand(numte,dim);         % testing data
tel = (rand(numte,1) > 0.5)+1; % testing labels {1,2}


%
% train an svm classifier using the 
% intersection kernel -t 4
%
model = svmtrain(trl,trd,'-s 0 -t 4'); % -s 0 use c svm formulation
                                       % -t 4 use intersection kernel


%
%  Evaluate the model using standard and various fast techniques
%

				      
% standard evaluation (brute force)

tic;
[p,acc,dec] = svmpredict(tel,ted,model);
svmtime=toc;

% loop over number of divisions (bins) used in approximations

nbins = [10 20 30 40 50 80 100 150 200 250 300];
clear err_e; clear err_pwc; clear err_pwl; clear ft;
for i = 1:length(nbins)
  % options for fastpredict
  % -v 0  turn off verbose output ( -v 1 for verbose output)
  % -n #  set the number of division (bins) per coordinate for approximations
  teststring = sprintf('-v 0 -n %d',nbins(i));
  % call the fastprediction code
  [fe,fpwc,fpwl,ft(i,:)] = fastpredict(tel,ted,model,teststring);
  % output for exact (binary search), pwconst, pwlinear, and
  % timing numbers
  
  % compute how well each method recreates the brute force calcuation
  % from the svmpredict call above.  Exact binary search should give
  % the same answer ans brute force.  Piecewise cosntant and piecewise
  % linear are both approximations should close given enough divisions (bins)
  err_e(i)   = mean(abs(dec-fe));
  err_pwc(i) = mean(abs(dec-fpwc));
  err_pwl(i) = mean(abs(dec-fpwl));
end

%% Plots
figure;
hold on;
plot(nbins,err_e,'--r*');
plot(nbins,err_pwc,'--g*');
plot(nbins,err_pwl,'--b*');
legend('exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)']);
title('Error in Approximation of Exact vs. Number of Bins');

xlabel('Number of Bins');
ylabel('Error in Approximation of Exact');
grid on;
set(gca,'XTick',nbins)

figure;
hold on;
plot(nbins,ft(:,1),'--k*');
plot(nbins,ft(:,2),'--r*');
plot(nbins,ft(:,3),'--g*');
plot(nbins,ft(:,4),'--b*');
legend('precomp','exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)']);

title(sprintf('Classification Time vs #bins\n(libsvm=%.2fs , %d examples, %d sup vec, %d dim)',svmtime,numte,model.totalSV,dim));
xlabel('Number of Bins');
ylabel('Classification Time(s)');
grid on;
set(gca,'XTick',nbins)


%%
%% Accuracy/Time vs. Number of Suport Vectors
%%

numtrs = [100 200 500 1000 1500];
numte = 50000;
dim = 100;
%test data%
ted = rand(numte,dim);
tel = (rand(numte,1) > 0.5)+1;
nbins = 100;
clear err_e; clear err_pwc; clear err_pwl; clear ft;clear nsv;svmtime;
for i = 1:length(numtrs)
    %training data%
    numtr = numtrs(i);
    trd = rand(numtr,dim);
    trl = (rand(numtr,1) > 0.5)+1;

    model = svmtrain(trl,trd,'-s 0 -t 4');
    tic;
    [p,acc,dec] = svmpredict(tel,ted,model);
    svmtime(i)=toc;
    nsv(i) = model.totalSV;
    teststring = sprintf('-v 0 -n %d',nbins);
    [fe,fpwc,fpwl,ft(i,:)] = fastpredict(tel,ted,model,teststring); 
    err_e(i)   = mean(abs(dec-fe));
    err_pwc(i) = mean(abs(dec-fpwc));
    err_pwl(i) = mean(abs(dec-fpwl));
end
%% Plots

figure;
hold on;
plot(nsv,err_e,'--r*');
plot(nsv,err_pwc,'--g*');
plot(nsv,err_pwl,'--b*');
legend('exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)'],'Location','NorthWest');
title('Error in Approximation of Exact vs. Number of Support Vectors');

xlabel('Number of Support Vectors');
ylabel('Error in Approximation of Exact');
grid on;
set(gca,'XTick',nsv)

figure;
hold on;
plot(nsv,svmtime,'-rd');
plot(nsv,ft(:,1),'--k*');
plot(nsv,ft(:,2),'--r*');
plot(nsv,ft(:,3),'--g*');
plot(nsv,ft(:,4),'--b*');

%semilogy(nsv,svmtime,'-rd');
%hold on;
%semilogy(nsv,ft(:,1),'--k*');
%semilogy(nsv,ft(:,2),'--r*');
%semilogy(nsv,ft(:,3),'--g*');
%semilogy(nsv,ft(:,4),'--b*');

legend('libsvm','precomp','exact (binary search)','approx (piecewise constant)',['approx (piecewise ' ...
                    'linear)'],'Location','NorthWest');

title(sprintf('Classification Time vs # Support Vectors\n(%d examples, %d dim, nbins %d)',numte,dim,nbins));
xlabel('Number of Support Vectors');
ylabel('Classification Time(s)');
grid on;
set(gca,'XTick',nsv)
