#ifndef INTERSECTIONCLASSIFIER_H
#define INTERSECTIONCLASSIFIER_H
#include "svm.h"


class IntersectionClassifier{
 public:
  IntersectionClassifier(svm_model* model,int nBins,int featureDim);
  ~IntersectionClassifier();

  double* predict(svm_model* model,double** data,int num);
  double* fastPredict(svm_model *model, double** data,int num);
  double* fastPredictFlip(svm_model *model, double** data,int num);
  double* linHashPredict(svm_model *model, double** data,int num);
  double* pwConstPredict(svm_model *model, double** data,int num);
  double* pwLinPredict(svm_model *model, double** data,int num);
  double* linSimulate(svm_model * model, double ** data, int num);
  
 private:
  void precompute(svm_model* model,int nBins);
  void clipData(double** data,int num); //clips the data so that its within min and max in each dim
  void print();

  int dim;
  int nSV;
  double** sortSV;    // dim x nSV
  double** cumalphax; //dim x nSV
  double** cumalpha;  //dim x nSV
  
  
  //quicky intialize the binary search
  //linear Interpolation for ranking.
  double*  hCoef; 
  double*  hOff;
  int **   linearRank; //precomputed ranks for uniformly spaced values
  int nBins;

  //precompute the values for uniformly spaced bins
  double** hDimValue;
  
  
};

#endif
