if(1)
if(1)
   load ct101_meta.mat %metadata
   meta.base_dir = '../data/101_ObjectCategories/';
else
  meta.base_dir = '/Users/aberg/data/101_ObjectCategories/';
  meta.base_dir = '/mnt/local/2/aberg/caltech_101/101_ObjectCategories/';
  % finds all the image names, records class directory, etc. in
  % variable called meta
  [D,Dext] = my_dir_dir(meta.base_dir,'*');

  count = 0;
  for i=1:length(D),
    object_dir = [Dext(i).name '/'];
    [DD,DDext] = my_dir([meta.base_dir object_dir],'*.jpg');
    images.cat_names{i} = Dext(i).name;
    for j=1:length(DD),
      images.im_name{count+j}=DDext(j).name;
      images.cat(count+j)=i;
    end
    count = count+length(DD);
  end
end


% params for descriptor

nbins=8;
nl=4;
canny_sigma = 1;
canny_thresh = 0.2;
nbinsSVM=60; %#bins for piecewise linear approximation


% compute descriptor for each image, store in cell array called ad
% (all descriptors)
% takes about 40 mins on one machine
% there is a precomputed version in descriptors_2_8_4.mat
% this has 2 sets of oe histograms (ala lazebnik's work and slightly different from the code below)
count=size(images.im_name,2);

dodesc=0;
fprintf(1,'Computing descriptors..');
if(dodesc)
    tic
    for j=1:nl,
    ad{j}=zeros(nbins*4^(j-1),count);
    end
    for ind=1:count,
        I = imread([meta.base_dir images.cat_names{images.cat(ind)} '/' images.im_name{ind}]);
        descriptor = compute_sp_hog(I,nbins,nl,canny_thresh,canny_sigma);
        for j=1:length(descriptor),
            d =descriptor{j}';
            ad{j}(:,ind) = d(:);
        end
        fprintf('done %d of %d\r',ind,count);
    end
    toc
    % this is commented out to avoid over writing the descriptor file
    save descriptors_1_8_4.mat ad
else
    load descriptors_2_8_4.mat ad
end;
fprintf(1,'[done]\n');



% put the desriptors into a matrix, one col for each image

% count how many components are in a descriptor
tl = 0;
for i=1:length(ad),
  tl = tl + size(ad{i},1);
end

count=size(ad{1},2);


% add will be the matrix of descriptors, with some weight for each level
add = zeros(tl,count);
cl=0;
for i=1:length(ad), % looping through levels
  adn = ad{i};
  s=sum(adn);
  adn = adn./repmat(s,[size(adn,1) 1]);
  add(cl+1:cl+size(ad{i},1),:)=(4^i)*adn;
  cl=cl+size(ad{i},1);
end


% make nadd, L1  normalized add
s = sum(add);
nadd = add./repmat(s,[size(add,1), 1]);
nadd=nadd';
end;


% k-fold cross validation
kfold=5; 
% make training / test split
ntrain = [15 30]; ntest = 50;

%pwl_sgd params
params.use_sqrt       = 0;
params.ndivs          = 50;
params.pwl_lambda     = 1; %optimized using cross validation
params.pwc_lambda     = 2 ; %optimized using cross validation
params.iters          = 10000;
params.k              = 10;
params.class_1_weight = 10;
%liblinear params
params.enc_svm_type   = 3;
params.C              = 0.0001;


do_one_vs_one=0;
if(do_one_vs_one)
    malin = zeros(length(ntrain),kfold);
    maint = zeros(length(ntrain),kfold);
    clear alin; clear aint;
    for i = 1:length(ntrain);
        rand('twister',1000); %for repeatability
        fprintf('1-vs-1 classifiers:ntrain=%i, ntest=%i\n',ntrain(i),ntest);
        for j = 1:kfold
            [all_train_cat,training_vecs,all_test_cat,testing_vecs]=...
                train_test_split(ntrain(i),ntest,images,nadd);
            [alin{i,j},aint{i,j}] = classify_one_vs_one(all_train_cat,training_vecs,...
                                                    all_test_cat, testing_vecs);
            
            malin(i,j) = mean(alin{i,j}(2:end));
            maint(i,j) = mean(aint{i,j}(2:end));
            fprintf(1,'linear:%.2f int:%.2f\n',malin(i,j), maint(i,j));
        end
        fprintf('\t Linear SVM : %.2f (%.2f)\n',mean(malin(i,:)),sqrt(var(malin(i,:))));
        fprintf('\t     IK SVM : %.2f (%.2f)\n',mean(maint(i,:)),sqrt(var(maint(i,:))));
    end
else
    A = cell(length(ntrain),kfold); %accuracices
    T = cell(length(ntrain),kfold); %training times
    for i = 1:length(ntrain);
        rand('twister',1000); %for repeatability
        for j = 1:kfold
            fprintf('1-vs-all classifiers: ntrain %i, ntest %i, round %i\n',ntrain(i),ntest,j);
            [all_train_cat,training_vecs,all_test_cat,testing_vecs]=...
                train_test_split(ntrain(i),ntest,images,nadd);
            [A{i,j},T{i,j}] = classify_one_vs_all_snow(all_train_cat,training_vecs,...
                                                all_test_cat, testing_vecs,params);
        end
    end
end 