load pwl_data.mat
[ntrain,nfold]=size(A);
numtrain = [15 30];
for i = 1:ntrain
    tt = zeros(3,nfold);
    aa = zeros(3,nfold);
    for j = 1:nfold
        tt(1,j) = T{i,j}.enc_train;
        tt(2,j) = T{i,j}.pwl_train;
        tt(3,j) = T{i,j}.pwc_train;
        aa(1,j) = A{i,j}.enc_acc;
        aa(2,j) = A{i,j}.pwl_acc;
        aa(3,j) = A{i,j}.pwc_acc;
    end
    %print them out
    fprintf('\n\nAccuracy %i+ per cat :\n',numtrain(i));
    fprintf('\t  liblinear : %.2f (%.2f)\n',mean(aa(1,:)),sqrt(var(aa(1,:))));
    fprintf('\t  pwl_sgd   : %.2f (%.2f)\n',mean(aa(2,:)),sqrt(var(aa(2,:))));
    fprintf('\t  pwc_sgd   : %.2f (%.2f)\n',mean(aa(3,:)),sqrt(var(aa(3,:))));
    fprintf('Training Times (seconds):\n');
    fprintf('\t  liblinear : %.2f (%.2f)\n',mean(tt(1,:)),sqrt(var(tt(1,:))));
    fprintf('\t  pwl_sgd   : %.2f (%.2f)\n',mean(tt(2,:)),sqrt(var(tt(2,:))));
    fprintf('\t  pwc_sgd   : %.2f (%.2f)\n',mean(tt(3,:)),sqrt(var(tt(3,:))));
end